require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require_relative '../base/base'

class Home < Base
  include PageObject

  def initialize(driver)
    super(driver)
  end

  expected_title "VA Tool Set"
  h3(:home_welcome_message, :id => 'home-welcome-user')
  h3(:sectionLabel, :css => '.section-header')

  #primary title
  h2(:primary_header, :css => '.primary-header>h2')
  div(:unauthorized_welcome_message, :css=> '.welcome')

  #VAR Utility
  img(:varUtilImg, :css => '#var-utility-plaque img')
  h4(:varUtilTitle, :css => '#var-utility-plaque h4')
  p(:varUtilText1, :css => '#var-utility-plaque p:first-of-type')
  p(:varUtilText2, :css => '#var-utility-plaque p:nth-of-type(2)')
  button(:varUtilOpen, :css => '#open-var-utility-btn')

  #Assessment Builder
  img(:assessmentImg, :css => '#assessment-builder-plaque img')
  h4(:assessmentTitle, :css => '#assessment-builder-plaque h4')
  p(:assessmentText1, :css => '#assessment-builder-plaque p:first-of-type')
  p(:assessmentText2, :css => '#assessment-builder-plaque p:nth-of-type(2)')
  button(:assessmentOpen, :css => '#open-assessment-builder-btn')
end


